<!DOCTYPE html>
<?php

global $Globals;

?>
<html lang="ro">
<head>
    <meta charset="utf-8">
    <!--<meta name="viewport" content="user-scalable=no, width=device-width, height=device-height, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0" />-->
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	
    <meta name="description"	content="<?php bloginfo( 'description' ); ?>">
	<meta name="keywords"		content="<?php bloginfo( 'name' ); ?>">
    <meta name="author"			content="Cristian Boldisor">

	<title><?php bloginfo( 'name' ); ?></title>

	<link rel="apple-touch-icon" sizes="180x180" href="<?=$Globals['site_url']?>/apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="<?=$Globals['site_url']?>/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="<?=$Globals['site_url']?>/favicon-16x16.png">
	<link rel="manifest" href="<?=$Globals['site_url']?>/site.webmanifest">
	
	<link href="https://fonts.googleapis.com/css?family=Montserrat:300,400,700" rel="stylesheet">

	<!-- FontAwesome -->
	<script defer src="https://use.fontawesome.com/releases/v5.0.8/js/all.js"></script>
	<!-- Google captcha -->
	<!-- <script src='https://www.google.com/recaptcha/api.js'></script> -->
	
	<!-- CDN CSS -->
	<!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous"> -->
	
	<!-- Imported CSS -->
	<link rel="stylesheet" href="<?=$Globals['template_directory']?>/import/swiper.min.css">
	
	<!-- Custom CSS -->
	<link rel="stylesheet" href="<?=$Globals['template_directory']?>/style.css">
	
	<link rel="stylesheet" href="<?=$Globals['template_directory']?>/css/layout.css">
	<link rel="stylesheet" href="<?=$Globals['template_directory']?>/css/common.css">
	<link rel="stylesheet" href="<?=$Globals['template_directory']?>/css/elements.css">
	
	<link rel="stylesheet" href="<?=$Globals['template_directory']?>/css/header.css">
	<link rel="stylesheet" href="<?=$Globals['template_directory']?>/css/primary.css">
	<link rel="stylesheet" href="<?=$Globals['template_directory']?>/css/footer.css">
	
	<link rel="stylesheet" href="<?=$Globals['template_directory']?>/css/misc.css">
	
	<?php wp_head(); ?>
	
</head>

<body>

	<!--
	<div class="loader on" id="site-loader"><div class="spinner"></div></div>
	-->
	
	<header id="page-header">
		<div class="container clear-after">
			<div id="conf-logo">
				<a href="<?php echo $Globals['home_url']; ?>">
					<img src="<?=$Globals['template_directory']?>/img/logo.jpg" />
				</a>
			</div>
			<div id="site-name">
				<h1 id="conf-name">
					The 6th International Conference <br/>
					New Trends on Sensing - Monitoring - Telediagnosis for Life Sciences <br/>
					NT-SMT-LS 2022
				</h1>
				<div id="conf-info">
					September 8 - 10, 2022 <br/>
					Brașov, România <br/>
				</div>
				<div id="conf-info-2">
					(on site and online participation)
				</div>
			</div>
			<div id="conf-organizers"><?php 
				$posts2 = get_posts(array(
					'numberposts'	=> -1,
					'post_type'		=> 'partener'
				));
				if( $posts2 ) : 
					global $post; 
					?>
					<div class="swiper-container header-swiper" data-swiper-effect="slide" data-swiper-speed="1000" data-swiper-loop="true" data-swiper-autoplay="true" data-swiper-autoplay-delay="3000">
						<div class="swiper-wrapper"><?php
							foreach( $posts2 as $post ) :
								setup_postdata( $post ); 
								$logo = get_field( 'partner_logo' );
								$name = get_field( 'partner_name' );
								if ( !$name ) {
									$name = get_the_title();
								}
								$link = get_field( 'partner_url' ); 
								?>
								<div class="swiper-slide widget-slide">
									<a href="<?php echo $link; ?>" target="_blank" title="<?php the_title(); ?>">
										<span class="widget-slide-image"><img src="<?php echo $logo; ?>" /></span>
										<span class="widget-slide-caption"><?php echo $name; ?></span>
									</a>	
								</div>
								<?php 
							endforeach;
							wp_reset_postdata();
						?>
						</div>
					</div><?php
				else :
				endif; 
				?>
			</div>
		</div>
		<?php 
			$args = array(
				'theme_location'		=> 'primary',
				'container_class' 		=> 'menu-container',
				'container_id' 			=> 'main-menu-container',
				'menu_class' 			=> 'menu container',
				'menu_id' 				=> 'main-menu'
			);
			wp_nav_menu($args);
		?>
	</header>
	
	
	
	
	
	